/*
 * @(#)UIDefaultsTableModel.java 1.2  2004-05-22
 *
 * Copyright (c) 2001-2005 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.randelshofer.debug;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * Table model for UIDefaults.
 *
 * @author  Werner Randelshofer
 * @version 1.2 2004-05-22 UIDefaults key does not necessarily have to be a
 * String.
 * <br>1.1 2003-03-16
 */
public class UIDefaultsTableModel extends AbstractTableModel {
    private Object[][] data;
    private final static String[] columnNames = { "Key", "Value" };
    
    public UIDefaultsTableModel(UIDefaults p) {
        setUIDefaults(p);
    }
    public void setUIDefaults(UIDefaults p) {
        HashMap combinedDefaults = new HashMap();
        // We need this very bogus code to retrieve all the defaults, because
        // the UIDefaults class returned by the UIManager is bogus. :(
        for (Enumeration iter = UIManager.getDefaults().keys(); iter.hasMoreElements(); ) {
            Object key = iter.nextElement();
            combinedDefaults.put(key, UIManager.get(key));
        }
        for (Iterator iter = UIManager.getDefaults().keySet().iterator(); iter.hasNext(); ) {
            Object key = iter.next();
            combinedDefaults.put(key, UIManager.get(key));
        }
        for (Enumeration iter = p.keys(); iter.hasMoreElements(); ) {
            String key = (String) iter.nextElement();
            combinedDefaults.put(key, p.get(key));
        }
        data = new Object[combinedDefaults.size()][2];
        int i = 0;
        for (Iterator iter = combinedDefaults.entrySet().iterator(); iter.hasNext(); ) {
            Map.Entry entry = (Map.Entry) iter.next();
            data[i][0] = entry.getKey().toString();
            data[i][1] = entry.getValue();
            i++;
        }
        Arrays.sort(data, new Comparator() {
            public int compare(Object o1, Object o2) {
                return ((String) ((Object[]) o1)[0]).compareTo((String) ((Object[]) o2)[0]);
            }
        });
        fireTableDataChanged();
    }
    
    public int getColumnCount() {
        return 2;
    }
    
    public int getRowCount() {
        return data.length;
    }
    
    public Object getValueAt(int row, int col) {
        return data[row][col];
    }
    
    public String getColumnName(int col) {
        return columnNames[col];
    }
}